/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.launcher;

import java.awt.AWTException;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jivesoftware.openfire.launcher.DroppableFrame;
import org.jivesoftware.openfire.launcher.DroppableTextPane;
import org.jivesoftware.openfire.launcher.GraphicUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class Launcher {
    private String appName;
    private File binDir;
    private Process openfired;
    private File configFile;
    private JPanel toolbar = new JPanel();
    private ImageIcon offIcon;
    private ImageIcon onIcon;
    private TrayIcon trayIcon;
    private JFrame frame;
    private JPanel cardPanel = new JPanel();
    private CardLayout cardLayout = new CardLayout();
    private JTextPane pane;
    private boolean freshStart = true;

    public Launcher() throws AWTException {
        SystemTray tray = null;
        try {
            tray = SystemTray.getSystemTray();
        }
        catch (Throwable e2) {
            System.err.println("Error loading system tray library, system tray support disabled.");
        }
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e3) {
            e3.printStackTrace();
        }
        this.appName = System.getProperty("app.name") != null ? System.getProperty("app.name") : "Openfire";
        this.binDir = new File("").getAbsoluteFile();
        if (System.getProperty("appdir") != null) {
            this.binDir = new File(System.getProperty("appdir"));
        }
        this.configFile = new File(new File(this.binDir.getParent(), "conf"), "openfire.xml");
        this.frame = new DroppableFrame(){

            @Override
            public void fileDropped(File file) {
                String fileName = file.getName();
                if (fileName.endsWith(".jar") || fileName.endsWith(".war")) {
                    Launcher.this.installPlugin(file);
                }
            }
        };
        this.frame.setTitle(this.appName);
        JPanel mainPanel = new JPanel();
        JLabel splashLabel = null;
        this.cardPanel.setLayout(this.cardLayout);
        try {
            ImageIcon splash = new ImageIcon(this.getClass().getClassLoader().getResource("splash.gif"));
            splashLabel = new JLabel("", splash, 0);
            this.onIcon = new ImageIcon(this.getClass().getClassLoader().getResource("openfire_on-16x16.gif"));
            this.offIcon = new ImageIcon(this.getClass().getClassLoader().getResource("openfire_off-16x16.gif"));
            this.frame.setIconImage(this.offIcon.getImage());
        }
        catch (Exception e4) {
            e4.printStackTrace();
        }
        mainPanel.setLayout(new BorderLayout());
        this.cardPanel.setBackground(Color.white);
        JButton startButton = new JButton("Start");
        startButton.setActionCommand("Start");
        JButton stopButton = new JButton("Stop");
        stopButton.setActionCommand("Stop");
        JButton browserButton = new JButton("Launch Admin");
        browserButton.setActionCommand("Launch Admin");
        JButton quitButton = new JButton("Quit");
        quitButton.setActionCommand("Quit");
        this.toolbar.setLayout(new GridBagLayout());
        this.toolbar.add((Component)startButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.toolbar.add((Component)stopButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.toolbar.add((Component)browserButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.toolbar.add((Component)quitButton, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        mainPanel.add((Component)this.cardPanel, "Center");
        mainPanel.add((Component)this.toolbar, "South");
        PopupMenu menu = new PopupMenu(this.appName + " Menu");
        final MenuItem showMenuItem = new MenuItem("Hide");
        showMenuItem.setActionCommand("Hide/Show");
        menu.add(showMenuItem);
        MenuItem startMenuItem = new MenuItem("Start");
        startMenuItem.setActionCommand("Start");
        menu.add(startMenuItem);
        MenuItem stopMenuItem = new MenuItem("Stop");
        stopMenuItem.setActionCommand("Stop");
        menu.add(stopMenuItem);
        MenuItem browserMenuItem = new MenuItem("Launch Admin");
        browserMenuItem.setActionCommand("Launch Admin");
        menu.add(browserMenuItem);
        menu.addSeparator();
        MenuItem quitMenuItem = new MenuItem("Quit");
        quitMenuItem.setActionCommand("Quit");
        menu.add(quitMenuItem);
        browserButton.setEnabled(false);
        stopButton.setEnabled(false);
        browserMenuItem.setEnabled(false);
        stopMenuItem.setEnabled(false);
        ActionListener actionListener = e -> {
            if ("Start".equals(e.getActionCommand())) {
                this.frame.setCursor(Cursor.getPredefinedCursor(3));
                startButton.setEnabled(false);
                stopButton.setEnabled(true);
                startMenuItem.setEnabled(false);
                stopMenuItem.setEnabled(true);
                this.startApplication();
                this.frame.setIconImage(this.onIcon.getImage());
                this.trayIcon.setImage(this.onIcon.getImage());
                Thread thread = new Thread(() -> {
                    try {
                        Thread.sleep(8000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (stopButton.isEnabled()) {
                        browserButton.setEnabled(true);
                        browserMenuItem.setEnabled(true);
                        this.frame.setCursor(Cursor.getDefaultCursor());
                    }
                });
                thread.start();
            } else if ("Stop".equals(e.getActionCommand())) {
                this.stopApplication();
                this.frame.setIconImage(this.offIcon.getImage());
                this.trayIcon.setImage(this.offIcon.getImage());
                this.frame.setCursor(Cursor.getDefaultCursor());
                browserButton.setEnabled(false);
                startButton.setEnabled(true);
                stopButton.setEnabled(false);
                browserMenuItem.setEnabled(false);
                startMenuItem.setEnabled(true);
                stopMenuItem.setEnabled(false);
            } else if ("Launch Admin".equals(e.getActionCommand())) {
                this.launchBrowser();
            } else if ("Quit".equals(e.getActionCommand())) {
                this.stopApplication();
                System.exit(0);
            } else if ("Hide/Show".equals(e.getActionCommand()) || "PressAction".equals(e.getActionCommand())) {
                this.toggleVisibility(showMenuItem);
            }
        };
        startButton.addActionListener(actionListener);
        stopButton.addActionListener(actionListener);
        browserButton.addActionListener(actionListener);
        quitButton.addActionListener(actionListener);
        quitMenuItem.addActionListener(actionListener);
        browserMenuItem.addActionListener(actionListener);
        stopMenuItem.addActionListener(actionListener);
        startMenuItem.addActionListener(actionListener);
        showMenuItem.addActionListener(actionListener);
        this.trayIcon = new TrayIcon(this.offIcon.getImage(), this.appName, menu);
        this.trayIcon.setImageAutoSize(true);
        this.trayIcon.addActionListener(actionListener);
        this.trayIcon.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 1) {
                    Launcher.this.toggleVisibility(showMenuItem);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        if (tray != null) {
            tray.add(this.trayIcon);
        }
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Launcher.this.stopApplication();
                System.exit(0);
            }

            @Override
            public void windowIconified(WindowEvent e) {
                Launcher.this.frame.setVisible(false);
                showMenuItem.setLabel("Show");
            }
        });
        this.cardPanel.add("main", splashLabel);
        this.frame.getContentPane().add((Component)mainPanel, "Center");
        this.frame.pack();
        this.frame.setSize(400, 300);
        this.frame.setResizable(true);
        GraphicUtils.centerWindowOnScreen(this.frame);
        this.frame.setVisible(true);
        final ImageIcon icon = new ImageIcon(this.getClass().getClassLoader().getResource("splash2.gif"));
        this.pane = new DroppableTextPane(){

            @Override
            public void paintComponent(Graphics g) {
                Dimension size = Launcher.this.pane.getSize();
                int x = (size.width - icon.getIconWidth()) / 2;
                int y = (size.height - icon.getIconHeight()) / 2;
                g.setColor(Color.white);
                g.fillRect(0, 0, size.width, size.height);
                g.drawImage(icon.getImage(), x, y, null);
                this.setOpaque(false);
                super.paintComponent(g);
            }

            @Override
            public void fileDropped(File file) {
                String fileName = file.getName();
                if (fileName.endsWith(".jar") || fileName.endsWith(".war")) {
                    Launcher.this.installPlugin(file);
                }
            }
        };
        this.pane.setEditable(false);
        JPanel bevelPanel = new JPanel();
        bevelPanel.setBackground(Color.white);
        bevelPanel.setLayout(new BorderLayout());
        bevelPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        bevelPanel.add((Component)new JScrollPane(this.pane), "Center");
        this.cardPanel.add("running", bevelPanel);
        startButton.doClick();
    }

    public static void main(String[] args) throws AWTException {
        new Launcher();
    }

    private void toggleVisibility(MenuItem showMenuItem) {
        if (this.frame.isVisible()) {
            this.frame.setVisible(false);
            showMenuItem.setLabel("Show");
        } else {
            this.frame.setVisible(true);
            this.frame.setState(0);
            showMenuItem.setLabel("Hide");
        }
    }

    private synchronized void startApplication() {
        if (this.openfired == null) {
            block11: {
                try {
                    File windowsExe = new File(this.binDir, "openfired.exe");
                    File unixExe = new File(this.binDir, "openfired");
                    if (windowsExe.exists()) {
                        this.openfired = Runtime.getRuntime().exec(new String[]{windowsExe.toString()});
                        break block11;
                    }
                    if (unixExe.exists()) {
                        this.openfired = Runtime.getRuntime().exec(new String[]{unixExe.toString()});
                        break block11;
                    }
                    throw new FileNotFoundException();
                }
                catch (Exception e) {
                    try {
                        File libDir = new File(this.binDir.getParentFile(), "lib").getAbsoluteFile();
                        this.openfired = Runtime.getRuntime().exec(new String[]{"java", "-jar", new File(libDir, "startup.jar").toString()});
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        JOptionPane.showMessageDialog(null, "Launcher could not start,\n" + this.appName, "File not found", 0);
                    }
                }
            }
            final SimpleAttributeSet styles = new SimpleAttributeSet();
            SwingWorker<String, Void> inputWorker = new SwingWorker<String, Void>(){

                @Override
                public String doInBackground() {
                    if (Launcher.this.openfired != null) {
                        try (InputStream in = Launcher.this.openfired.getInputStream();){
                            int c;
                            while ((c = in.read()) != -1) {
                                try {
                                    StyleConstants.setFontFamily(styles, "courier new");
                                    Launcher.this.pane.getDocument().insertString(Launcher.this.pane.getDocument().getLength(), "" + (char)c, styles);
                                }
                                catch (BadLocationException badLocationException) {}
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    return "ok";
                }
            };
            inputWorker.execute();
            SwingWorker<String, Void> errorWorker = new SwingWorker<String, Void>(){

                @Override
                public String doInBackground() {
                    if (Launcher.this.openfired != null) {
                        try (InputStream in = Launcher.this.openfired.getErrorStream();){
                            int c;
                            while ((c = in.read()) != -1) {
                                try {
                                    StyleConstants.setForeground(styles, Color.red);
                                    Launcher.this.pane.getDocument().insertString(Launcher.this.pane.getDocument().getLength(), "" + (char)c, styles);
                                }
                                catch (BadLocationException badLocationException) {}
                            }
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    return "ok";
                }
            };
            errorWorker.execute();
            if (this.freshStart) {
                try {
                    Thread.sleep(1000L);
                    this.cardLayout.show(this.cardPanel, "running");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.freshStart = false;
            } else {
                this.pane.setText("");
                this.cardLayout.show(this.cardPanel, "running");
            }
        }
    }

    private synchronized void stopApplication() {
        if (this.openfired != null) {
            try {
                try (OutputStreamWriter out = new OutputStreamWriter(new BufferedOutputStream(this.openfired.getOutputStream()));){
                    out.write("exit\n");
                }
                Thread waiting = Thread.currentThread();
                Thread waiter = new Thread(() -> {
                    try {
                        this.openfired.waitFor();
                        waiting.interrupt();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                });
                waiter.start();
                try {
                    Thread.sleep(10000L);
                    waiter.interrupt();
                    this.openfired.destroy();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.cardLayout.show(this.cardPanel, "main");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.openfired = null;
    }

    static Document parse(File configFile) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        return factory.newDocumentBuilder().parse(configFile);
    }

    private synchronized void launchBrowser() {
        try {
            Element securePortElement;
            Document document = Launcher.parse(this.configFile);
            Element rootElement = document.getDocumentElement();
            Element adminElement = (Element)rootElement.getElementsByTagName("adminConsole").item(0);
            String port = "-1";
            String securePort = "-1";
            Element portElement = (Element)adminElement.getElementsByTagName("port").item(0);
            if (portElement != null) {
                port = portElement.getTextContent();
            }
            if ((securePortElement = (Element)adminElement.getElementsByTagName("securePort").item(0)) != null) {
                securePort = securePortElement.getTextContent();
            }
            if ("-1".equals(port)) {
                Desktop.getDesktop().browse(URI.create("https://127.0.0.1:" + securePort + "/index.html"));
            } else {
                Desktop.getDesktop().browse(URI.create("http://127.0.0.1:" + port + "/index.html"));
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            JOptionPane.showMessageDialog(new JFrame(), String.valueOf(this.configFile) + " " + e.getMessage());
        }
    }

    private void installPlugin(final File plugin) {
        final JDialog dialog = new JDialog(this.frame, "Installing Plugin", true);
        dialog.getContentPane().setLayout(new BorderLayout());
        JProgressBar bar = new JProgressBar();
        bar.setIndeterminate(true);
        bar.setString("Installing Plugin.  Please wait...");
        bar.setStringPainted(true);
        dialog.getContentPane().add((Component)bar, "Center");
        dialog.pack();
        dialog.setSize(225, 55);
        SwingWorker<File, Void> installerThread = new SwingWorker<File, Void>(){

            @Override
            public File doInBackground() {
                File pluginsDir = new File(Launcher.this.binDir.getParentFile(), "plugins");
                String tempName = plugin.getName() + ".part";
                File tempPluginsFile = new File(pluginsDir, tempName);
                File realPluginsFile = new File(pluginsDir, plugin.getName());
                try {
                    Thread.sleep(2000L);
                    Launcher.copy(plugin.toURI().toURL(), tempPluginsFile);
                    tempPluginsFile.renameTo(realPluginsFile);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return realPluginsFile;
            }

            @Override
            public void done() {
                dialog.setVisible(false);
            }
        };
        installerThread.execute();
        dialog.setLocationRelativeTo(this.frame);
        dialog.setVisible(true);
    }

    private static void copy(URL src, File dst) throws IOException {
        try (InputStream in = src.openStream();
             FileOutputStream out = new FileOutputStream(dst);){
            dst.mkdirs();
            Launcher.copy(in, out);
        }
    }

    private static void copy(InputStream in, OutputStream out) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[4096];
        while ((bytesRead = in.read(buffer)) >= 0) {
            out.write(buffer, 0, bytesRead);
        }
    }
}

